function SSSet(k,v){
	sessionStorage.setItem(k,v);
};
function SSGet(k){
	return sessionStorage.getItem(k);
};
function SSDel(k){
	sessionStorage.removeItem(k);
};

var imd = (function ($) {
	return {
		MAX_UINT32: 0xffffffff,
		cookie:{
			uid:"uid",
			sid:"sid"
		},
	}
})(jQuery);

// sessionStorage
var imss = (function ($) {
	return {
		login:"Login",
		srv:{	
			center:"SrvCenter",
			node:"SrvNode",
		},
		sys:{
			id:"SysID",
			cfg:"SysCfg",
		},
		d:{
			user:"dUser",
			uinfo:"dUInfo",
			org:"dOrg",
		},
		t:{
			user:"tUser",
			uinfo:"tUInfo",
			org:"tOrg",
		},
	}
})(jQuery);

var imurl = (function ($) {
	return {
		Login:"login.html",
		Main:"main.html",
	}
})(jQuery);

var imapi = (function ($) {
	return {
		Download: "/Download",
		ClientUpdate: "/ClientUpdate",
		Login: "/Login",
		Logout: "/Logout",
		Reg: "/Reg",
		SysCfg: "/SysCfg",
		Online: "/Online",
		Pwd: "/Pwd",
		User: "/User",
		Org: "/Org",
		Uc: "/Uc",
		Group: "/Group",
		Session: "/Session",
		Msg: "/Msg",
		SysMsg: "/SysMsg",
		AddUsers: "/AddUsers",
		ListUser: "/List/User",
		ListOnline: "/List/Online",
		ListUc: "/List/Uc",
		ListGroup: "/List/Group",
		ListSysMsg: "/List/SysMsg",
	}
})(jQuery);

var imf = (function ($) {
	return {
		V:function(v){
			if(v)return v;else return '';
		},
		TestEmail: function (eml) {
			var reg = /^[_a-zA-Z0-9]+@([_a-zA-Z0-9]+\.)+[a-zA-Z0-9]{2,5}$/;
			return reg.test(eml);
		},
		HtmlEncode: function (str) {
			return $("<textarea />").text(str).html();
		},
		HtmlDecode: function (str) {
			return $("<textarea />").html(str).text();
		},
		GetParameterByName: function (name, url) {
			if (!url) url = window.location.href;
			name = name.replace(/[\[\]]/g, "\\$&");
			var regex = new RegExp("[?&]" + name + "(=([^&#]*)|&|#|$)"),
				results = regex.exec(url);
			if (!results) return null;
			if (!results[2]) return null;
			return decodeURIComponent(results[2].replace(/\+/g, " "));
		},
		Go:function(u){
			window.location.assign(u);
		},
		GoLoginURL: function () {
			SSDel(imss.sys.id);
			SSDel(imss.sys.cfg);
			SSDel(imss.d.user);
			SSDel(imss.t.user);
			SSDel(imss.d.uinfo);
			SSDel(imss.t.uinfo);
			SSDel(imss.d.org);
			SSDel(imss.t.org);

			var v = JSON.parse(SSGet(imss.login));
			if (v == null || v.url == null){
				window.location.assign(imurl.Login);
				return;
			}
			window.location.assign(v.url);
		},
		GetUrlRoot: function () {
			var vLogin = JSON.parse(SSGet(imss.login));
			if (vLogin == null || vLogin.server == null || vLogin.port == null) return null;
			else return "https://" + vLogin.server + ":" + vLogin.port;
		},
		GetUrl: function (u,t=true) {	// t:是否判断登录已超时
			if(t && this.TimeoutChk())return null;
			var url = this.GetUrlRoot();
			if (url == null) return null;
			else return url + u;
		},
		_week_day: ["[日]", "[一]", "[二]", "[三]", "[四]", "[五]", "[六]"],
		WeekNum: function (ts) {
			var dt = new Date(ts * 1000);
			var b = new Date(dt.getFullYear(), 0, 1);
			var days = Math.floor((dt - b) / (24 * 60 * 60 * 1000));
			return Math.ceil((dt.getDay() + 1 + days) / 7);
		},
		TimeStr: function (ts) {
			var cur = new Date();
			var dt = new Date(ts * 1000);
			var stime = (dt.getHours() < 10) ? ("0" + dt.getHours().toString()) : dt.getHours().toString();
			stime += ":";
			stime += (dt.getMinutes() < 10) ? ("0" + dt.getMinutes().toString()) : dt.getMinutes().toString();
			var sdate = (dt.getMonth() < 10) ? ("0" + dt.getMonth().toString()) : dt.getMonth().toString();
			sdate += "-";
			sdate += (dt.getDate() < 10) ? ("0" + dt.getDate().toString()) : dt.getDate().toString();
			if (cur.getFullYear() == dt.getFullYear()) {
				if (cur.getMonth() == dt.getMonth()) {
					if (cur.getDate() == dt.getDate()) return stime;

					var wn = this.WeekNum(ts);
					if (this.WeekNum(cur.getTime() / 1000) == wn) {
						return this._week_day[dt.getDay()] + " " + stime;
					}
				}
				return sdate + this._week_day[dt.getDay()] + " " + stime;
			}
			return dt.getFullYear() + "-" + sdate + this._week_day[dt.getDay()] + " " + stime;
		},
		DlgClose: function (btn) {
			$("#" + btn.data('dlgid')).modal('hide');
		},
		DlgTimeout:function(){
			SSDel(imss.t.uinfo);
			SSDel(imss.d.uinfo);
			$("#Timeout").modal('toggle'); 
		},
		TimeoutUpd: function () {
			var uid = $.cookie(imd.cookie.uid);
			var sid = $.cookie(imd.cookie.sid);
			if (uid == null || sid == null) return;

			var et = new Date();
			et.setTime(et.getTime() + 15 * 60 * 1000);
			$.cookie(imd.cookie.uid, uid, { expires: et, path: '/' });
			$.cookie(imd.cookie.sid, sid, { expires: et, path: '/' });
		},
		TimeoutChk: function () {
			var uid = $.cookie(imd.cookie.uid);
			var sid = $.cookie(imd.cookie.sid);
			return uid == null || sid == null;
		},
		HttpGet: function (url, fs, fe) {
			if(url==null || url.length<=0)return;
			$.ajax({
				url: url,
				method: "GET",
				beforeSend:function(xhr){
					xhr.withCredentials=true
				},
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				dataType: "json",
				cache: false,
				success: fs,
				error: fe
			});
		},
		HttpPost: function (url, jv, fs, fe) {
			if(url==null || url.length<=0)return;
			$.ajax({
				url: url,
				method: "POST",
				beforeSend:function(xhr){
					xhr.withCredentials=true
				},
				xhrFields: {
					withCredentials: true
				},
				crossDomain: true,
				data: JSON.stringify(jv),
				dataType: "json",
				cache: false,
				success: fs,
				error: fe
			});
		}
	}
})(jQuery);

